/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// Pixie Sticks by eiffie
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


#define ITERATIONS 2
#define STEPS 32

#define time iGlobalTime
#define size iResolution
float focalDistance=1.0,aperture=0.01;

vec3 mcol;
const vec4 scale=vec4(-2.0,-2.0,-2.0,2.0);
vec3 norm;
float mr,mxr;
float DE(in vec3 z0){//amazing surface by kali/tglad with mods
	vec4 z = vec4(z0,1.0);
	for (int n = 0; n < ITERATIONS; n++) {
		z.xyz-=2.0*min(0.0,dot(z.xyz,norm))*norm;
		z.xy=clamp(z.xy, -1.0, 1.0) *2.0-z.xy;
		z*=scale/clamp(dot(z.xyz,z.xyz),mr,mxr);
	}
	mcol+=z.xyz;
	return (length(z.xz)-0.5)/z.w;
}

float pixelSize;
float CircleOfConfusion(float t){//calculates the radius of the circle of confusion at length t
	return max(abs(focalDistance-t)*aperture,pixelSize*(1.0+t));
}
mat3 lookat(vec3 fw,vec3 up){
	fw=normalize(fw);vec3 rt=normalize(cross(fw,normalize(up)));return mat3(rt,cross(rt,fw),fw);
}
//random seed and generator
float randSeed=fract(cos((gl_FragCoord.x+gl_FragCoord.y*117.0+time*10.0)*473.7192451));
float randStep(){//a simple very pseudo random number generator based on iq's hash
	return  (0.8+0.2*fract(sin(++randSeed)*43758.5453123));
}

#define PI 3.1416
void main() {
	pixelSize=1.0/size.y;
	float tim=time*0.25,st=cos(tim)*4.0;
	tim/=PI;
	tim+=0.125;
	float fT=floor(tim);
	tim=min(fract(tim)*4.0,1.0);
	vec3 ro=vec3(-st,1.0,st);
	float stm=sin(fT-1.0);
	st=sin(fT);
	norm=mix(vec3(-0.66+stm*0.33,stm*0.25,-0.3-stm*0.1),vec3(-0.66+st*0.33,st*0.25,-0.3-st*0.1),tim);
	mr=mix(0.25+stm*0.25,0.25+st*0.25,tim);
	mxr=mix(1.0-stm*0.25,1.0-st*0.25,tim);
	norm=normalize(norm);
	vec3 rd=lookat(-ro,vec3(1.0,0.0,0.0))*normalize(vec3((2.0*gl_FragCoord.xy-size.xy)/size.y,2.0));
	vec3 L=normalize(vec3(0.9,0.25,-0.5));
	vec4 col=vec4(0.0);//color accumulator
	float t=DE(ro)*randStep();//distance traveled
	ro+=rd*t;
	for(int i=0;i<STEPS;i++){//march loop
		if(col.w>0.9 || t>10.0)continue;//bail if we hit a surface or go out of bounds
		float rCoC=CircleOfConfusion(t);//calc the radius of CoC
		mcol=vec3(0.0);//clear color trap
		float d=DE(ro)+rCoC*0.25;
		if(d<rCoC){//if we are inside add its contribution
			vec3 p=ro+rd*(d-rCoC);//back up to border of CoC
			vec2 v=vec2(rCoC*0.1,0.0);//use normal deltas based on CoC radius
			vec3 N=normalize(vec3(-DE(p-v.xyy)+DE(p+v.xyy),-DE(p-v.yxy)+DE(p+v.yxy),-DE(p-v.yyx)+DE(p+v.yyx)));
			if(N!=N)N=-rd;
			mcol=vec3(0.7,0.4,0.4)+sin(mcol*0.1)*0.3;
			vec3 scol=mcol.rgb*0.5*(1.0+dot(N,L));
			scol+=pow(max(0.0,dot(reflect(rd,N),L)),32.0)*vec3(0.5,0.25,0.0);
			float alpha=(1.0-col.w)*smoothstep(-rCoC,rCoC,-d);//calculate the mix like cloud density
			col+=vec4(scol*alpha,alpha);//blend in the new color
		}
		d=max(d,pixelSize)*randStep();//add in noise to reduce banding and create fuzz
		ro+=d*rd;//march
		t+=d;
	}//mix in background color
	vec3 scol=rd*0.05+vec3(0.4,0.5,0.6)*max(0.0,dot(rd,L))+pow(max(0.0,dot(rd,L)),100.0)*vec3(1.0,0.75,0.5);
	col.rgb+=scol*(1.0-clamp(col.w,0.0,1.0));

	gl_FragColor = vec4(clamp(col.rgb,0.0,1.0),1.0);
}
